;/* ///////////////////////////////////////////////////////////////////////// */
;/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
;/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
;/*  Computing Systems, Vol. X, Issue Y.                                      */
;/* ------------------------------------------------------------------------- */
;/*  The source code is released under GPL license.                           */
;/*                                                                           */
;/*  Copyright, 2011                                                          */
;/*  Multimedia Embedded Systems Labs                                         */
;/*  Dept. of Computer Science                                                */
;/*  National Chiao Tung University                                           */
;/*  Hsinchu, Taiwan.                                                         */
;/* ///////////////////////////////////////////////////////////////////////// */

    .state32

    .sect ".intvecs"
    .global _reset

; /** the ARM exception vector space */
_reset:
    ldr     pc,     addr_onReset
    ldr     pc,     addr_onUndefined
    ldr     pc,     addr_onSWI
    ldr     pc,     addr_onPrefetchAbort
    ldr     pc,     addr_onDataAbort
    ldr     pc,     addr_onUndefined           ; /**< unassigned vector location */
    ldr     pc,     addr_onIRQ
    ldr     pc,     addr_onFIQ

    .global   _onReset
    .global   _onUndefined
    .global   _onSWI
    .global   _onPrefetchAbort
    .global   _onDataAbort
    .global   _onIRQ
    .global   _onFIQ
    .global   _SvcStack
    
    .global   _init

; /** function pointers to the various exception handlers */
addr_onReset           .word   _onReset
addr_onUndefined       .word   _onUndefined
addr_onSWI             .word   _onSWI
addr_onPrefetchAbort   .word   _onPrefetchAbort
addr_onDataAbort       .word   _onDataAbort
addr_onIRQ             .word   _onIRQ
addr_onFIQ             .word   _onFIQ

; /** function pointer to the init function */
addr_init              .word   _init

; /** stack initialization */
addr_svcStack          .word   _svcStack
svcStackSize           .word   1024

_onReset:

; /** switch to SVC mode */
    mrs     r0, cpsr
    bic     r0, r0, #0x1F
    orr     r0, r0, #0x13
    msr     cpsr, r0
; /** set-up the SVC mode stack before jumping into code written in C */
    ldr     sp, addr_svcStack
    ldr     r0, svcStackSize     ; /**< size of the stack */
    add     sp, sp, r0
    b       _init

; /** the SVC mode stack */
_svcStack: .usect ".svcStack", 1024, 4

